# delimit ; 
clear all; 
set mem 300m;	
set more 1 ;  
drop _all;
program drop _all;
capture log close;


*log using E:\Dropbox\hrs\wealthcouples\healtrans_4states.log, replace ; 
log using c:\Dropbox\hrs\wealthcouples\healtrans_4states.log, replace ; 
*log using c:\research\hrs\wealthcouples\healtrans_4states.log, replace ; 

*cd E:\Dropbox\hrs\wealthcouples;
cd C:\Dropbox\hrs\wealthcouples;
*cd C:\research\hrs\wealthcouples;

local graphs=1 ;

use dataprep2_4states;
* use c:\Dropbox\hrs\wealthcouples\dataprep2_4states;
*use E:\Dropbox\hrs\wealthcouples\dataprep2_4states;
*use c:\research\hrs\wealthcouples\dataprep2_4states;

*decide whether to focus only on those who started as part of a couple;
* keep if firsthh==3; 
*Once died, no relevant transtions to calculate;
*drop if died==.;
drop if hhdead==1 & mandied~=1 & womandied~=1;

*lag age vars;
gen lage1=lhhage;
gen lage2=lage1*lage1/100;
gen lage3=lage2*lage1/100;

*IMPORTANT: henceforth "age" will refer to lagged age ;
drop age*;

rename lage1 age1;
rename lage2 age2;
rename lage3 age3;
*rename lhhage age;

*lage_w contains real age for single and married women;
gen age1_w=lage_w;
gen age2_w=age1_w*age1_w/100;
gen age3_w=age2_w*age1_w/100;

* generate dummy variables for current and lagged values of heal;
gen manheal3=(manheal==3);
gen manheal2=(manheal==2);
gen manheal1=(manheal==1);
gen manheal0=(manheal==0);

gen lmanheal3=(lmanheal==3);
gen lmanheal2=(lmanheal==2);
gen lmanheal1=(lmanheal==1);
gen lmanheal0=(lmanheal==0);

gen womanheal3=(womanheal==3);
gen womanheal2=(womanheal==2);
gen womanheal1=(womanheal==1);
gen womanheal0=(womanheal==0);

gen lwomanheal3=(lwomanheal==3);
gen lwomanheal2=(lwomanheal==2);
gen lwomanheal1=(lwomanheal==1);
gen lwomanheal0=(lwomanheal==0);

rename lmanheal1 lmanheal_nur;
rename lmanheal2 lmanheal_bad;
rename lmanheal3 lmanheal_good;

rename lwomanheal1 lwomanheal_nur;
rename lwomanheal2 lwomanheal_bad;
rename lwomanheal3 lwomanheal_good;

*keep PI and lagged health around;
gen PIholder=PI;
gen lmanhealage_bad=lmanheal_bad*age1;
gen lmanhealage_nur=lmanheal_nur*age1;
gen lmanhealage_good=lmanheal_good*age1;

gen lwomanhealage_bad=lwomanheal_bad*age1_w;
gen lwomanhealage_nur=lwomanheal_nur*age1_w;
gen lwomanhealage_good=lwomanheal_good*age1_w;
*gen maleage=male*age1;
drop PIage;
*gen PIage=PI*age1;
*gen lcoupleage=lcouple*age1;

*gen PIage_w=PI*age1_w;
*gen lcoupleage_w=lcouple*age1_w;

*tab firsthh;
*pause;

* this next line of code makes a duplicate observation for every initial couple (where firsthh==3); 
expand 2 if firsthh==3;

sort HHID wave;
gen heal2=manheal if firsthh==2|(firsthh==3 & HHID==HHID[_n-1] & wave==wave[_n-1]);
replace heal2=womanheal if firsthh==1|(firsthh==3 & HHID==HHID[_n+1] & wave==wave[_n+1]);
gen male2=1 if firsthh==2|(firsthh==3 & HHID==HHID[_n-1] & wave==wave[_n-1]);
replace male2=0 if firsthh==1|(firsthh==3 & HHID==HHID[_n+1] & wave==wave[_n+1]);
gen age1_2=age1 if male2==1;
replace age1_2=age1_w if male2==0;
gen age2_2=age1_2*age1_2/100;
gen age3_2=age2_2*age1_2/100;

gen lcoupleage=lcouple*age1_2;
gen male_lcouple=male2*lcouple;
gen male_lcoupleage=male2*lcoupleage;

sort HHID male2 wave;
gen lheal2= heal2[_n-1] if HHID==HHID[_n-1] & male2==male2[_n-1];

gen lheal_3=(lheal2==3);
gen lheal_2=(lheal2==2);
gen lheal_1=(lheal2==1);
gen lheal_0=(lheal2==0);

rename lheal_1 lheal_nur;
rename lheal_2 lheal_bad;
rename lheal_3 lheal_good;

gen lhealage_bad=lheal_bad*age1_2;
gen lhealage_nur=lheal_nur*age1_2;
gen lhealage_good=lheal_good*age1_2;

gen PIage    = PI*age1_2;
gen maleage  = male2*age1_2;
gen maleage2 = male2*age2_2;
gen maleage3 = male2*age3_2;

gen malePI= male2*PI;
gen malePI2= male2*PI2;
gen malePIage = male2*PIage;
gen male_lheal_bad = male2*lheal_bad;
gen male_lhealage_bad = male2*lhealage_bad ;
gen male_lheal_good = male2*lheal_good;
gen male_lhealage_good = male2*lhealage_good;

gen lcouplePI = lcouple * PI;
gen male_lcouplePI= male2*lcouplePI;

drop if heal2==.|lheal2==.|age1_2==.|PI==.|male2==.;
keep heal2 age1_2 age2_2 age3_2 PI PI2 PIage lcouple lcoupleage lheal_bad lhealage_bad lheal_good lhealage_good male2 maleage
	   malePI male_lcouple lcouplePI HHID wave;

save health_trans, replace;

*drop if firsthh==3;
/*
*2 mtx base in 1mtx version;
mlogit heal2 age1_2 age2_2 age3_2 PI PI2 PIage lcouple lcoupleage lheal_bad lhealage_bad lheal_good lhealage_good 
       male2 maleage maleage2 maleage3 malePI malePI2 malePIage male_lcouple male_lcoupleage male_lheal_bad male_lhealage_bad 
	   male_lheal_good male_lhealage_good lcouplePI male_lcouplePI, baseoutcome(0); 
estimates store A;
*/	   
*1 mtx w/ male, maleage, malePI, lcouple, lcoupleage, lcouplemale, lcouplePI;
mlogit heal2 age1_2 age2_2 age3_2 PI PI2 PIage lcouple lcoupleage lheal_bad lhealage_bad lheal_good lhealage_good male2 maleage
	   malePI male_lcouple lcouplePI, baseoutcome(0);
/*
estimates store B;

*simple spec;
mlogit heal2 age1_2 age2_2 age3_2 PI PI2 PIage lheal_bad lhealage_bad lheal_good lhealage_good male2 maleage, baseoutcome(0);
estimates store C;
	   
lrtest A B, stats;
lrtest A C, stats;
lrtest B C, stats;
*/	   
drop _all;
set obs 18;
forval i=1/3 {;
gen var`i' = [`i']_b[_cons] in 1;
replace var`i'=[`i']_b[age1_2] in 2;
replace var`i'=[`i']_b[age2_2] in 3;
replace var`i'=[`i']_b[age3_2] in 4;
replace var`i'=[`i']_b[PI] in 5;
replace var`i'=[`i']_b[PI2] in 6;
replace var`i'=[`i']_b[PIage] in 7;
replace var`i'=[`i']_b[male2] in 8;
replace var`i'=[`i']_b[maleage] in 9;
replace var`i'=[`i']_b[malePI] in 10;
replace var`i'=[`i']_b[lcouple] in 11;
replace var`i'=[`i']_b[lcoupleage] in 12;
replace var`i'=[`i']_b[male_lcouple] in 13;
replace var`i'=[`i']_b[lcouplePI] in 14;
replace var`i'=[`i']_b[lheal_bad] in 15;
replace var`i'=[`i']_b[lhealage_bad] in 16;
replace var`i'=[`i']_b[lheal_good] in 17;
replace var`i'=[`i']_b[lhealage_good] in 18;
};


*outsheet using E:\Dropbox\hrs\wealthcouples\hstransh_041713_sing_1mtx_specB, nonames replace;
*outsheet using c:\Dropbox\hrs\wealthcouples\hstransh_041713_sing_1mtx_specB, nonames replace;
*outsheet using C:\research\hrs\wealthcouples\hstransh_041713_sing_1mtx_specB, nonames replace;
outsheet using hstransh_102317_sing_1mtx_specB, nonames replace;

exit;
	   

